<?php
session_start();
include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
} 
?>
<?php
include 'manager_data.php';

// Connect to MT5 server
if (($error_code = $api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, MT5_CONNECTION_TIMEOUT, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK) {
    echo "Connection failed with error: " . MTRetCode::GetError($error_code);
    exit();
} else {
    // Fetch user logins
    $logins = [];
    $group = ""; // Leave empty to fetch all users or specify a group if needed
    $result = $api->UserLogins($group, $logins);

    if ($result !== MTRetCode::MT_RET_OK) {
        echo "Error fetching user logins: " . MTRetCode::GetError($result);
        exit();
    }
}

?>

<!DOCTYPE html>
<html>
<head>
   <?php include 'style.php';?>
</head>
<body>

<?php include 'header.php';?>

<div class="topnav" style="background-color:#1d1d1d">

    <a href="manager.php" class="split"><i class="fa fa-users"></i> &nbsp;&nbsp;Manager</a>
    <a href="master.php" class="split" style="background-color:#ff6c2c;border-radius:20px"><i class="fa fa-line-chart"></i> &nbsp;&nbsp;Master</a>
    <a href="index.php" class="split" ><i class="fa fa-user"></i> &nbsp;&nbsp;Profiles</a>
</div>

<div class="container">
    <div class="table-container">
        <h2 style="text-align:center; color: #fff;">Master Account</h2>
        <!-- Search Bar -->
        <div class="search-bar">
            <!--<input type="text"  id="search-input" placeholder="Search Master..." />-->
            <a href="add_master.php"><button style='background-color:blue;color:white;padding:10px;width:150px;border-radius:10px;border:none;outline:none'><i class="fa fa-plus"></i> &nbsp;&nbsp;Add Master</button></a>
        </div>
        <!-- Table -->
        <div style="overflow-x:auto;">
            <table id="client-table">
                <thead>
                    <tr>
                    <th>Sr no</th>
                    <th>Trade ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Balance</th>
                    <th>Free Margin</th>
                    <th>Account Types</th>
                    <th>Add Slave</th>
                    <th>View Slave</th>
                    <th>Remove Master</th>
                    <!--<th>Remove All Master</th>-->
                </tr>
                </thead>
               <tbody>
                       <?php
                       $cnt = 1;
                                                    $sql = "SELECT * FROM tbl_master WHERE login=:login";
                                                    $query = $dbh->prepare($sql);
                                                    $query->bindParam(':login', $logined, PDO::PARAM_STR);
                                                    $query->execute();
                                                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                                                    $cnt = 1;
                                                    if ($query->rowCount() > 0) {
                                                        foreach ($results as $result) {
                                                            
                                                            
                                                    ?>
                                                    
                                                     <tr>
        <td><?php echo $cnt++; ?></td>
        <td><?php echo htmlentities($result->tradeid); ?></td>
<td><?php echo htmlentities($result->name); ?></td>
<td><?php echo htmlentities($result->email); ?></td>
<td>
    <?php
    $login = htmlentities($result->tradeid);
    $result2 = $api->UserAccountGet($login, $user2);
    echo $balance = $user2->Balance;
    ?>
</td>

<td>
    <?php
    $login = htmlentities($result->tradeid);
    $result2 = $api->UserAccountGet($login, $user2);
    echo $margin = $user2->Margin;
    ?>
</td>


<td><?php echo htmlentities($result->account); ?></td>
<td><a href='add_slave.php?mastertrade=<?php echo htmlentities($result->tradeid); ?>'><i class="fa fa-plus-circle" style="color:#00f541;font-size:25px"></i></a></td>
<td><a href='view_slave.php?tradeid=<?php echo htmlentities($result->tradeid); ?>'><i class="fa fa-eye" style="color:white;font-size:25px"></i></a></td>

<?php
$tradeid = htmlentities($result->tradeid);
$sql2 = "SELECT * FROM tbl_slave WHERE mastertrade=:tradeid";
$query2 = $dbh->prepare($sql2);
$query2->bindParam(':tradeid', $tradeid, PDO::PARAM_STR);
$query2->execute();
$cnt2 = $query2->rowCount(); // Get the number of rows
?>

<td>
    <?php if ($cnt2 > 0) { ?>
        <a href="#" onclick="showAlertAndRedirect(event)"><i class="fa fa-remove" style="color:red;font-size:25px"></i></a>
    <?php } else { ?>
        <a href='delete_master.php?tradeid=<?php echo htmlentities($result->tradeid); ?>'>
            <i class="fa fa-remove" style="color:red;font-size:25px"></i>
        </a>
    <?php } ?>
</td>

<!--<td>-->
<!--<a href='delete_master.php?tradeid=<?php echo htmlentities($result->tradeid); ?>'>-->
<!--            <i class="fa fa-remove" style="color:red;font-size:25px"></i>-->
<!--        </a>-->
<!--</td>-->

<script>
function showAlertAndRedirect(event) {
    event.preventDefault(); // Prevent default action

    let alertDiv = document.createElement('div');
    alertDiv.innerHTML = 'Remove slave IDs to delete master trade ID';
    alertDiv.style.position = 'fixed';
    alertDiv.style.bottom = '20px';
    alertDiv.style.right = '20px';
    alertDiv.style.background = 'red';
    alertDiv.style.color = 'white';
    alertDiv.style.padding = '10px 20px';
    alertDiv.style.borderRadius = '5px';
    alertDiv.style.boxShadow = '0px 0px 10px rgba(0, 0, 0, 0.2)';
    alertDiv.style.fontSize = '14px';
    alertDiv.style.zIndex = '9999';
    alertDiv.style.transition = 'opacity 0.5s';
    document.body.appendChild(alertDiv);
    
    setTimeout(() => {
        alertDiv.style.opacity = '0';
        setTimeout(() => alertDiv.remove(), 500);
    }, 3000);
    
    setTimeout(() => {
        window.location.href = 'view_slave.php?tradeid=<?php echo $tradeid;?>'; // Change this to your redirect page
    }, 3500);
}
</script>

 </tr>
     <?php }
                                                    } ?>
   
               </tbody>
            </table>
        </div>
    </div>
</div>


<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var input = this.value.toLowerCase();
        var rows = document.querySelectorAll('#client-table tbody tr');
        rows.forEach(function(row) {
            var rowText = row.textContent.toLowerCase();
            row.style.display = rowText.includes(input) ? '' : 'none';
        });
    });
</script>


</body>
</html>

<?php
// Disconnect from MT5 server
$api->Disconnect();
?>
