<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once __DIR__ . "/config.php";

try {
    // Only select the required columns
    $sql = "SELECT rank_id, rank_name, min_active_clients, rank_number FROM ranks ORDER BY rank_number ASC";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $ranks = [];
        while ($row = $result->fetch_assoc()) {
            $ranks[] = $row;
        }
        echo json_encode([
            "success" => true,
            "message" => "Ranks fetched successfully.",
            "data" => $ranks
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "No ranks found.",
            "data" => []
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "message" => "Error: " . $e->getMessage()
    ]);
}

$conn->close();
?>
