<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

include_once __DIR__ . "/config.php";

// Fetch all rewards
$sql = "SELECT id, lots_required, reward_amount, status, created_at FROM lots_reward ORDER BY id DESC";
$result = $conn->query($sql);

$rewards = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $rewards[] = [
            "id"            => (int)$row["id"],
            "lots_required" => (float)$row["lots_required"],
            "reward_amount" => (float)$row["reward_amount"],
            "status"        => (int)$row["status"],
            "created_at"    => $row["created_at"]
        ];
    }
}

echo json_encode([
    "status" => "success",
    "rewards" => $rewards
]);
exit;
?>
