<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

ini_set('display_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . "/connection.php";
include_once __DIR__ . "/config.php";

try {

    $final = [];

    /* 1️⃣ deposit_requests (bonus only) */
    $q1 = "
        SELECT 
            dr.id AS request_id,
            dr.trade_id,
            dr.amount,
            dr.type AS bonus_type,
            dr.status,
            dr.created_at,
            l.account_name,
            l.account_type,
            l.email AS account_email,
            u.first_name,
            u.last_name,
            u.email AS user_email,
            u.phone
        FROM deposit_requests dr
        LEFT JOIN liveaccounts l ON l.trade_id = dr.trade_id
        LEFT JOIN loginusers u ON u.id = l.user_id
        WHERE dr.type = 'bonus'
        ORDER BY dr.created_at DESC
    ";

    $res1 = $conn->query($q1);
    while ($row = $res1->fetch_assoc()) {
        $row['source'] = "deposit_requests";
        $final[] = $row;
    }


    /* 2️⃣ wallet_deposit (bonus only) */
    $q2 = "
        SELECT 
            wd.id AS wallet_id,
            wd.trade_id,
            wd.deposit_amount AS amount,
            wd.deposit_type AS bonus_type,
            wd.Status AS status,
            wd.deposed_date AS created_at,
            l.account_name,
            l.account_type,
            l.email AS account_email,
            u.first_name,
            u.last_name,
            u.email AS user_email,
            u.phone
        FROM wallet_deposit wd
        LEFT JOIN liveaccounts l 
            ON l.trade_id COLLATE utf8mb4_general_ci = wd.trade_id COLLATE utf8mb4_general_ci
        LEFT JOIN loginusers u 
            ON u.email COLLATE utf8mb4_general_ci = wd.email COLLATE utf8mb4_general_ci
        WHERE wd.deposit_type = 'bonus'
        ORDER BY wd.deposed_date DESC
    ";

    $res2 = $conn->query($q2);
    while ($row = $res2->fetch_assoc()) {
        $row['source'] = "wallet_deposit";
        $final[] = $row;
    }


    /* 3️⃣ admin_bonus (add/remove bonus) */
    $q3 = "
        SELECT 
            ab.id AS bonus_id,
            ab.email,
            ab.trade_id,
            ab.amount,
            ab.action_type,
            ab.comment,
            ab.created_at,
            l.account_name,
            l.account_type,
            l.email AS account_email,
            u.first_name,
            u.last_name,
            u.email AS user_email,
            u.phone
        FROM admin_bonus ab
        LEFT JOIN liveaccounts l 
            ON l.trade_id COLLATE utf8mb4_general_ci = ab.trade_id COLLATE utf8mb4_general_ci
        LEFT JOIN loginusers u 
            ON u.email COLLATE utf8mb4_general_ci = ab.email COLLATE utf8mb4_general_ci
        ORDER BY ab.created_at DESC
    ";

    $res3 = $conn->query($q3);
    while ($row = $res3->fetch_assoc()) {
        $row['source'] = "admin_bonus";
        $row['bonus_type'] = $row['action_type']; 
        $final[] = $row;
    }


    echo json_encode([
        "success" => true,
        "total_bonus_records" => count($final),
        "bonus_data" => $final
    ]);
    exit;

} catch (Throwable $e) {

    echo json_encode([
        "success" => false,
        "error" => "Server error",
        "details" => $e->getMessage()
    ]);
    exit;
}
?>
