<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include_once __DIR__ . '/config.php';
include_once __DIR__ . '/connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

// Get JSON input
$input = json_decode(file_get_contents("php://input"), true);
$rank_id = intval($input['rank_id'] ?? 0);

if ($rank_id < 1) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid rank_id"
    ]);
    exit;
}

// Delete rank row
$stmt = $conn->prepare("DELETE FROM ranks WHERE rank_id = ?");
$stmt->bind_param("i", $rank_id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode([
            "status" => "success",
            "message" => "Rank deleted successfully",
            "rank_id" => $rank_id
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No rank found with this rank_id",
            "rank_id" => $rank_id
        ]);
    }
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Error: " . $conn->error
    ]);
}

$stmt->close();
?>
