<?php 
header("Content-Type: application/json; charset=UTF-8");
require_once "config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => false, "message" => "Invalid request method"]);
    exit();
}

// Read POST (form-data)
$wallet_name          = trim($_POST['wallet_name'] ?? '');
$wallet_address       = trim($_POST['wallet_address'] ?? '');
$payment_type         = trim($_POST['payment_type'] ?? '');
$status               = trim($_POST['status'] ?? 'active');

// Bank fields
$bank_account_holder  = trim($_POST['bank_account_holder'] ?? '');
$bank_payment_method  = trim($_POST['bank_payment_method'] ?? '');
$bank_iban            = trim($_POST['bank_iban'] ?? '');
$bank_swift           = trim($_POST['bank_swift'] ?? '');
$bank_name            = trim($_POST['bank_name'] ?? '');
$bank_address         = trim($_POST['bank_address'] ?? '');
$bank_country         = trim($_POST['bank_country'] ?? '');
$account_currency     = trim($_POST['account_currency'] ?? '');

// Handle QR upload
$qr_upload = null;
if (!empty($_FILES['qr_upload']['name'])) {
    $fileName = time() . "_" . basename($_FILES['qr_upload']['name']);
    $targetPath = "uploads/" . $fileName;

    if (move_uploaded_file($_FILES['qr_upload']['tmp_name'], $targetPath)) {
        $qr_upload = $targetPath;
    }
}

// INSERT INTO payment_methods
$sql = "INSERT INTO payment_methods 
        (wallet_name, wallet_address, payment_type, status, qr_upload, 
         bank_account_holder, bank_payment_method, bank_iban, bank_swift,
         bank_name, bank_address, bank_country, account_currency, created_at, updated_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";

$stmt = $conn->prepare($sql);

$stmt->bind_param(
    "sssssssssssss",
    $wallet_name,
    $wallet_address,
    $payment_type,
    $status,
    $qr_upload,
    $bank_account_holder,
    $bank_payment_method,
    $bank_iban,
    $bank_swift,
    $bank_name,
    $bank_address,
    $bank_country,
    $account_currency
);

// First insert execute
if ($stmt->execute()) {

    $pm_id = $stmt->insert_id;

    // INSERT INTO payment_methods_history
    $history_sql = "INSERT INTO payment_methods_history 
        (payment_method_id, action, wallet_name, wallet_address, payment_type, status, qr_upload,
         bank_account_holder, bank_payment_method, bank_iban, bank_swift,
         bank_name, bank_address, bank_country, account_currency)
        VALUES (?, 'added', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $history_stmt = $conn->prepare($history_sql);

    // FIX: MUST BE 1 int + 15 string = 16 parameters
    $history_stmt->bind_param(
        "isssssssssssss",
        $pm_id,
        $wallet_name,
        $wallet_address,
        $payment_type,
        $status,
        $qr_upload,
        $bank_account_holder,
        $bank_payment_method,
        $bank_iban,
        $bank_swift,
        $bank_name,
        $bank_address,
        $bank_country,
        $account_currency
    );

    $history_stmt->execute();
    $history_stmt->close();

    echo json_encode(["status" => true, "message" => "Payment method added successfully"]);

} else {

    echo json_encode([
        "status" => false,
        "message" => "Failed to add payment method",
    ]);
}

$stmt->close();
$conn->close();
?>
