<?php
function checkPermission($conn, $empId, $permission_name) {

    // 1. Fetch role_id of staff
    $stmt = $conn->prepare("SELECT role_id FROM adminlogins WHERE empId = ?");
    $stmt->bind_param("s", $empId);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if (!$user || !$user['role_id']) {
        return false;
    }

    $role_id = $user['role_id'];

    // 2. Check if role has given permission
    $stmt2 = $conn->prepare("
        SELECT p.name 
        FROM permissions p
        JOIN role_permissions rp ON p.id = rp.permission_id
        WHERE rp.role_id = ? AND p.name = ?
    ");
    $stmt2->bind_param("is", $role_id, $permission_name);
    $stmt2->execute();
    $res = $stmt2->get_result();

    return ($res->num_rows > 0);
}
?>
