<?php
session_start();
include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
} 
?>
<?php
include 'manager_data.php';

// Connect to MT5 server
if (($error_code = $api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, MT5_CONNECTION_TIMEOUT, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK) {
    echo "Connection failed with error: " . MTRetCode::GetError($error_code);
    exit();
} else {
    // Fetch user logins
    $logins = [];
    $group = ""; // Leave empty to fetch all users or specify a group if needed
    $result = $api->UserLogins($group, $logins);

    if ($result !== MTRetCode::MT_RET_OK) {
        echo "Error fetching user logins: " . MTRetCode::GetError($result);
        exit();
    }
}

$mastertrade = $_GET['tradeid'];

?>

<!DOCTYPE html>
<html>
<head>
   <?php include 'style.php';?>
</head>
<body>

<?php include 'header.php';?>

<div class="topnav" style="background-color:transparent">

    <a href="manager.php" class="split"><i class="fa fa-users"></i> &nbsp;&nbsp;Manager</a>
    <a href="master.php" class="split" style="background-color:#ff6c2c;border-radius:20px"><i class="fa fa-line-chart"></i> &nbsp;&nbsp;Master</a>
    <a href="index.php" class="split" ><i class="fa fa-user"></i> &nbsp;&nbsp;Profiles</a>
</div>

<div class="container">
    <div class="table-container">
        <h2 style="text-align:center; color: #fff;">View Slave</h2>
        <!-- Search Bar -->
<div style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
    <a href="add_slave.php?mastertrade=<?php echo $mastertrade;?>">
        <button style="background-color:#ff6c2c; color:white; padding:10px; border-radius:10px; border:none; outline:none;">
            <i class="fa fa-plus"></i> &nbsp;&nbsp;Add Slave
        </button>
    </a>

    <div class="search-bar" style="width:200px;padding-right:20px">
        <input type="text" id="search-input" placeholder="Search Slave..." style="width:100%;background-color:#ffa680;color:black" />
    </div>
</div>

        <!-- Table -->
        <div style="overflow-x:auto;">
            <table id="client-table">
                <thead>
                    <tr>
                    <th>Sr no</th>
                    <th>Trade ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Balance</th>
                    <th>Margin</th>
                    <th>Account</th>
                    <th>Leverage</th>
                    <th>Remove Slave</th>
                </tr>
                </thead>
               <tbody>
                    <?php
                     $cnt = 1; // Initialize serial number counter
                                                    $mastertrade = $_GET['tradeid'];
                                                    $sql = "SELECT * FROM tbl_slave WHERE mastertrade = :mastertrade AND login=:login";
                                                    $query = $dbh->prepare($sql);
                                                    $query->bindParam(':mastertrade', $mastertrade, PDO::PARAM_STR);
                                                    $query->bindParam(':login', $logined, PDO::PARAM_STR);
                                                    $query->execute();
                                                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                                                    $cnt = 1;
                                                    if ($query->rowCount() > 0) {
                                                        foreach ($results as $result) {
                                                    ?>
                                                    
                                                     <tr>
        <td><?php echo $cnt++; ?></td>
        <td><?php echo htmlentities($result->slavetrade); ?></td>
<td><?php echo htmlentities($result->name); ?></td>
<td><?php echo htmlentities($result->email); ?></td>
<td>
    <?php
    $login = htmlentities($result->slavetrade);
    $result2 = $api->UserAccountGet($login, $user2);
    echo $balance = $user2->Balance;
    ?>
</td>

<td>
    <?php
    $login = htmlentities($result->tradeid);
    $result2 = $api->UserAccountGet($login, $user2);
    echo $margin = $user2->Margin;
    ?>
</td>
<td><?php echo htmlentities($result->account); ?></td>
<td><?php echo htmlentities($result->leverage); ?></td>
<td><a href='delete_slave.php?slavetradeid=<?php echo htmlentities($result->slavetrade); ?>'><i class="fa fa-times-circle" style="color:red;font-size:25px"></i></a></td>
 </tr>
     <?php }
                                                    } ?>
   
               </tbody>
            </table>
        </div>
    </div>
</div>


<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var input = this.value.toLowerCase();
        var rows = document.querySelectorAll('#client-table tbody tr');
        rows.forEach(function(row) {
            var rowText = row.textContent.toLowerCase();
            row.style.display = rowText.includes(input) ? '' : 'none';
        });
    });
</script>


</body>
</html>

<?php
// Disconnect from MT5 server
$api->Disconnect();
?>
