<?php
session_start();
include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
    exit();
}

$mastertradeid  = $_GET['mastertradeid'];
$slavetradeid  = $_GET['slavetradeid'];
$name = $_GET['name'];
$email = $_GET['email'];
$balance = $_GET['balance'];
$group = $_GET['group'];
$loginid = $_GET['loginid'];
$leverage = $_GET['leverage'];

try {
    // Check if the slave trade already exists
    $checkQuery = "SELECT COUNT(*) FROM `tbl_slave` WHERE `mastertrade` = :mastertradeid AND `slavetrade` = :slavetradeid";
    $stmtCheck = $dbh->prepare($checkQuery);
    $stmtCheck->bindParam(':mastertradeid', $mastertradeid, PDO::PARAM_STR);
    $stmtCheck->bindParam(':slavetradeid', $slavetradeid, PDO::PARAM_STR);
    $stmtCheck->execute();
    $count = $stmtCheck->fetchColumn();

    if ($count > 0) {
        echo '
        <div class="success-container">
            <div class="tick-mark"><i class="fa fa-times-circle"></i></div>
            <div class="message">
                <strong>Failed!</strong> This Slave trade ID is already linked to the Master Account.
            </div>
        </div>';
        exit();
    }

    // Prepare the insert query for tbl_slave
    $query = "INSERT INTO `tbl_slave`(`mastertrade`, `slavetrade`, `name`, `email`, `balance`, `account`, `leverage`, `login`) 
              VALUES (:mastertradeid, :slavetradeid, :name, :email, :balance, :group, :leverage, :login)";
    $stmt = $dbh->prepare($query);
    $stmt->bindParam(':mastertradeid', $mastertradeid, PDO::PARAM_STR);
    $stmt->bindParam(':slavetradeid', $slavetradeid, PDO::PARAM_STR);
    $stmt->bindParam(':name', $name, PDO::PARAM_STR);
    $stmt->bindParam(':email', $email, PDO::PARAM_STR);
    $stmt->bindParam(':balance', $balance, PDO::PARAM_STR);
    $stmt->bindParam(':group', $group, PDO::PARAM_STR);
    $stmt->bindParam(':leverage', $leverage, PDO::PARAM_STR);
    $stmt->bindParam(':login', $loginid, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Prepare the insert query for tbl_copytrade
    $query2 = "INSERT INTO `tbl_copytrade`(`mastertrade`, `copytrade`, `login`)
              VALUES (:mastertradeid, :slavetradeid, :login)";
    $stmt2 = $dbh->prepare($query2);
    $stmt2->bindParam(':mastertradeid', $mastertradeid, PDO::PARAM_STR);
    $stmt2->bindParam(':slavetradeid', $slavetradeid, PDO::PARAM_STR);
    $stmt2->bindParam(':login', $loginid, PDO::PARAM_STR);
    $stmt2->execute();

    // Write master and slave trade IDs to user.txt
    $file = fopen("user.txt", "a");
    if ($file) {
        fwrite($file, $mastertradeid . ", " . $slavetradeid . "\n");
        fclose($file);
    } else {
        echo '
        <div class="success-container">
            <div class="tick-mark"><i class="fa fa-times-circle"></i></div>
            <div class="message">
                <strong>Failed!</strong> Some Error happened, try again later.
            </div>
        </div>';
        exit();
    }

    echo '
    <div class="success-container">
        <div class="tick-mark"><i class="fa fa-check-circle"></i></div>
        <div class="message">
            <strong>Success!</strong> Slave Added Successfully In Master Account.
        </div>
    </div>';

} catch (PDOException $e) {
    echo '
    <div class="success-container">
        <div class="tick-mark"><i class="fa fa-times-circle"></i></div>
        <div class="message">
            <strong>Failed!</strong> Some Error happened, try again later.
        </div>
    </div>';
}
?>




<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<div class="tab-pane fade in active" id="deposit-funds-on-account">
    </script>
        <style>
        .success-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 50px;
            background-color: #f4f9f4;
            border: 2px solid #28a745;
            border-radius: 10px;
            width: 300px;
            margin: 50px auto;
        }
        
        
        .failed-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 50px;
            background-color: #f4f9f4;
            border: 2px solid #c73b22;
            border-radius: 10px;
            width: 300px;
            margin: 50px auto;
        }

        .success-container2 .tick-mark {
            font-size: 50px;
            color: #c73b22;
        }

 .success-container .tick-mark {
            font-size: 50px;
            color: #28a745;
        }

        .success-container .message {
            margin-top: 20px;
            font-size: 18px;
            color: #333;
            text-align: center;
        }

        .success-container .message strong {
            color: #28a745;
        }
        
        .success-container2 .message strong {
            color: #c73b22;
        }
        
         .success-container .redirect-msg {
            margin-top: 10px;
            font-size: 14px;
            color: #666;
            text-align: center;
        }
    </style>


    

    <body>


<script>
        // Redirect after 3 seconds
        setTimeout(function() {
            window.location.href = "add_slave.php?mastertrade=<?php echo $mastertradeid;?>"; // Update with your desired URL
        }, 1000);
    </script>
</body>
    <script>
// select live trading Account Start*********************************************************
    document.querySelectorAll("[name=trade_id]")[0].addEventListener('change',
   function () {
       window.location = "add_slave.php?mastertrade=<?php echo $mastertradeid;?>";
   });
// select live trading Account End*********************************************************
        var d = new Date();
        // Set the value of the "date" field
        document.getElementById("mytime").value = d.toLocaleString();
        /* Set the value of the "time" field


        var hours = d.getHours();
        var minutes = d.getMinutes();
        var seconds = d.getSeconds();
        var DayNight = "PM";
        if (hours<12) DayNight = "AM";
        if (hours>12) hours = hours-12;
        if (hours===0) hours = 12;
        if (minutes<=9) minutes = "0"+minutes;
        if (seconds<=9) seconds = "0"+seconds;

        document.getElementById("time").value = hours+":"+minutes+":"+seconds+" "+DayNight;
        */
    </script>
    
</div>


