<?php
// Script to register Sagar Nandal and send verification email

// Include the main configuration
require_once 'unified_config.php';

// Test user data
$first_name = 'Sagar';
$last_name = 'Nandal';
$email = 'sagarnandal95@gmail.com';
$password = 'TestPassword123!';
$country = 'India';
$phone = '+91-9876543210';
$dob = '1995-01-01';

echo "🚀 Registering user: $first_name $last_name ($email)\n";
echo "==========================================\n";

// Generate unique referral ID
$newReferralId = rand(10000, 99999);
$uid = uniqid('user_');
$emailToken = bin2hex(random_bytes(16));
$wallet_address = "WAL" . rand(100000, 999999);

// Initialize IB chain
$ibChain = array_fill(1, 10, 'noIB');

echo "Generated User Details:\n";
echo "  UID: $uid\n";
echo "  Referral ID: $newReferralId\n";
echo "  Email Token: $emailToken\n";
echo "  Wallet Address: $wallet_address\n\n";

// Insert user data (simulated)
echo "📝 Simulating user registration in database...\n";
echo "  First Name: $first_name\n";
echo "  Last Name: $last_name\n";
echo "  Email: $email\n";
echo "  Country: $country\n";
echo "  Phone: $phone\n";
echo "  DOB: $dob\n";
echo "  Password: $password\n\n";

// Send registration verification email
echo "📧 Sending registration verification email...\n";

if (EMAIL_AUTOMATION_ENABLED) {
    $mailSystem = getMailSystem();
    $fullName = $first_name . ' ' . $last_name;
    
    $emailResult = $mailSystem->sendRegisterVerification($email, $fullName, $emailToken);
    
    if ($emailResult['success']) {
        echo "✅ Registration verification email sent successfully!\n";
        echo "   Message: " . $emailResult['message'] . "\n";
    } else {
        echo "❌ Failed to send registration verification email.\n";
        echo "   Error: " . $emailResult['message'] . "\n";
    }
} else {
    echo "⚠️ Email automation is disabled.\n";
}

echo "\n🎉 Registration process completed!\n";
echo "Please check your email inbox at $email for the verification email.\n";
?>