<?php
/**
 * Test MyKF Markets Webmail Configuration
 * Testing support@mykfmarkets.com with send.smtp.com server
 */

require_once 'mail_system.php';

echo "📧 Testing MyKF Markets webmail configuration...\n\n";

// Test sending email with new webmail configuration
$result = sendZForexMail(
    'mkroy101112@gmail.com',  // Send to mkroy for testing
    'MK Roy',
    'register_verification',
    [
        'verification_url' => 'https://mykfmarkets.com/verify?token=test123456'
    ]
);

if ($result['success']) {
    echo "✅ SUCCESS: Email sent successfully from MyKF Markets webmail!\n";
    echo "📧 Check inbox at mkroy101112@gmail.com\n";
    echo "📝 Subject: Email Verification Required\n";
    echo "🏢 From: MyKF Markets <support@mykfmarkets.com>\n";
    echo "🌐 Server: send.smtp.com (Custom webmail)\n";
} else {
    echo "❌ FAILED: " . $result['message'] . "\n";
    echo "🔧 Please check:\n";
    echo "   - Webmail server send.smtp.com is accessible\n";
    echo "   - Email credentials for support@mykfmarkets.com are correct\n";
    echo "   - Port 465 with SSL is properly configured\n";
    echo "   - Firewall allows outbound connections on port 465\n";
}

echo "\n📋 Current Webmail Configuration:\n";
echo "Host: " . MAIL_HOST . "\n";
echo "Port: " . MAIL_PORT . "\n";
echo "Username: " . MAIL_USERNAME . "\n";
echo "Encryption: " . MAIL_ENCRYPTION . "\n";
echo "From Email: " . MAIL_FROM_EMAIL . "\n";
echo "From Name: " . MAIL_FROM_NAME . "\n";
echo "Brand Name: " . BRAND_NAME . "\n";

echo "\n🔧 SMTP Settings Used:\n";
echo "Server Type: Custom Webmail (not Gmail)\n";
echo "SSL/TLS: SSL on port 465\n";
echo "Authentication: Enabled\n";

?>