<?php
/**
 * Test Gmail Connection
 * This script tests if the Gmail SMTP connection works with your credentials
 */

require_once 'mail_system.php';

echo "🧪 Testing Gmail SMTP Connection...\n\n";

// Test sending a simple email
$result = sendZForexMail(
    'sagarnandal95@gmail.com',  // Send to yourself for testing
    'Sagar Nandal',
    'register_verification',
    [
        'verification_url' => 'https://yoursite.com/verify?token=test123'
    ]
);

if ($result['success']) {
    echo "✅ SUCCESS: Email sent successfully!\n";
    echo "📧 Check your inbox at sagarnandal95@gmail.com\n";
    echo "📝 Subject: Email Verification Required\n";
} else {
    echo "❌ FAILED: " . $result['message'] . "\n";
    echo "🔧 Please check:\n";
    echo "   - Gmail app password is correct\n";
    echo "   - 2-factor authentication is enabled\n";
    echo "   - Less secure app access is disabled (use app password)\n";
}

echo "\n📋 Current Configuration:\n";
echo "Host: " . MAIL_HOST . "\n";
echo "Port: " . MAIL_PORT . "\n";
echo "Username: " . MAIL_USERNAME . "\n";
echo "Encryption: " . MAIL_ENCRYPTION . "\n";
echo "From Email: " . MAIL_FROM_EMAIL . "\n";

?>