# EcoTradeFX Mail System

This folder contains a complete, standalone mail system for EcoTradeFX with all necessary dependencies and configurations.

## 📁 Folder Structure

```
mail_system/
├── config.php                      # Mail configuration settings
├── mail_system.php                 # Core mail system class (ZForexMailer)
├── vendor/                         # PHPMailer dependencies (self-contained)
├── composer.json                   # Dependency management
├── composer.lock                   # Locked dependency versions
├── test_standalone_mail.php        # Quick test for the mail system
├── test_all_templates_branding.php # Test all email templates
├── test_ecotradefx_branding.php    # Test EcoTradeFX branding
└── README.md                       # This documentation
```

## 🚀 Quick Start

1. **Test the mail system:**
   ```bash
   cd mail_system
   php test_standalone_mail.php
   ```

2. **Send a quick email:**
   ```php
   require_once 'config.php';
   require_once 'mail_system.php';
   
   $mailer = new ZForexMailer();
   $mailer->sendMail('user@example.com', 'John Doe', 'register_verification', [
       'verification_url' => 'https://ecotradefx.com/verify/abc123'
   ]);
   ```

## 📧 Available Email Templates

The system includes 22 pre-configured email templates:

### Account Management
- `register_verification` - Email verification after registration
- `after_verify_credentials` - Welcome email after verification
- `login_alert` - Login notification
- `open_live_account` - Live account opening confirmation
- `password_reset` - Password reset instructions
- `password_changed` - Password change confirmation
- `profile_updated` - Profile update notification

### KYC & Verification
- `kyc_upload` - KYC document upload confirmation
- `kyc_approved` - KYC approval notification

### Deposits & Withdrawals
- `deposit_request_submitted` - Deposit request confirmation
- `deposit_approved` - Deposit approval notification
- `deposit_failed` - Deposit failure notification
- `deposit_unsuccessful` - Deposit unsuccessful notification
- `otp_withdrawal` - OTP for withdrawal
- `withdrawal_request_submitted` - Withdrawal request confirmation
- `withdrawal_approved` - Withdrawal approval notification
- `withdrawal_rejected` - Withdrawal rejection notification

### Trading & Commissions
- `trade_open` - Trade opening notification
- `trade_close` - Trade closing notification
- `daily_trade_summary` - Daily trading summary
- `ib_commission_withdrawal` - IB commission withdrawal
- `referral_registration` - Referral registration bonus

### Reports
- `monthly_statement` - Monthly account statement

## ⚙️ Configuration

### Mail Settings (config.php)
```php
define('BRAND_NAME', 'EcoTradeFX');
define('MAIL_FROM_NAME', 'EcoTradeFX');
define('MAIL_FROM_EMAIL', 'support@mykfmarkets.com');
define('MAIL_HOST', 'send.smtp.com');
define('MAIL_PORT', 465);
define('MAIL_ENCRYPTION', 'ssl');
```

### Logo Configuration
- **Logo URL:** `https://ecotradefx.com/lib/logo.png`
- **Styling:** Centered, responsive design
- **Format:** Online URL (better performance than base64)

## 🎨 Branding Features

- **Consistent Header:** All emails use the same EcoTradeFX header with logo
- **Brand Colors:** Professional color scheme
- **Responsive Design:** Works on all devices
- **Online Logo:** Fast loading from CDN

## 🧪 Testing

### Test All Templates
```bash
php test_all_templates_branding.php
```

### Test Specific Template
```php
$mailer = new ZForexMailer();
$result = $mailer->sendMail(
    'test@example.com',
    'Test User',
    'template_name',
    ['param1' => 'value1']
);
```

## 🔧 Customization

### Adding New Templates
1. Edit `mail_system.php`
2. Add new template in `loadTemplates()` function
3. Define subject, header, body, and button text
4. Test with your new template

### Updating Branding
1. Modify logo URL in `getEmailHTML()` function
2. Update brand colors in CSS section
3. Change brand name in `config.php`

## 📦 Dependencies

- **PHPMailer 6.9.1** (included in vendor folder)
- **PHP 7.4+** required
- **SMTP server** for sending emails

## 🔒 Security Features

- Secure SMTP authentication
- Input validation and sanitization
- No hardcoded credentials in templates
- Proper error handling

## 📝 Usage Examples

### Registration Email
```php
$mailer->sendMail($email, $name, 'register_verification', [
    'verification_url' => $verificationLink
]);
```

### Deposit Confirmation
```php
$mailer->sendMail($email, $name, 'deposit_approved', [
    'amount' => '$500.00',
    'transaction_id' => 'TXN123456'
]);
```

### Trade Notification
```php
$mailer->sendMail($email, $name, 'trade_open', [
    'symbol' => 'EUR/USD',
    'amount' => '0.1 lots',
    'price' => '1.0850'
]);
```

## 🚀 Deployment

This folder is completely self-contained and can be:
- Deployed independently
- Updated without affecting other systems
- Moved to different servers
- Version controlled separately

## 📞 Support

For mail system updates and maintenance, all code is contained within this folder. No external dependencies or modifications needed in other parts of the application.