<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include "config.php";

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $client_index = isset($_GET['client_index']) ? intval($_GET['client_index']) : 0;

    if ($client_index) {
        $sql = "SELECT 
                    a.client_index, a.username, a.email, a.gender, a.dob, a.number, a.address AS admin_address, 
                    a.company_name, a.userRole, a.userAccessLevel, a.status, 
                    k.document_number, k.address AS kyc_address, 
                    k.selfie_id_document, k.front_side, k.back_side, k.proof_of_address, 
                    k.created_at, k.updated_at
                FROM adminlogins a
                LEFT JOIN admin_kyc k ON a.client_index = k.client_index
                WHERE a.client_index = $client_index
                LIMIT 1";

        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo json_encode(["status" => "success", "data" => $row]);
        } else {
            echo json_encode(["status" => "error", "message" => "No data found for this user"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Client index required"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}
?>
    