<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

include_once __DIR__ . "/config.php";

// Fetch ALL users lots reward data (Admin) including new fields
$sql = "SELECT id, user_email, account_name, account_type, trade_start, trade_end, trade_id, lots_done, reward_amount, created_at 
        FROM lots_reward_users 
        ORDER BY id DESC";

$result = $conn->query($sql);

$users = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $users[] = [
            "id"            => (int)$row["id"],
            "user_email"    => $row["user_email"],
            "account_name"  => $row["account_name"],
            "account_type"  => $row["account_type"],
            "trade_start"   => $row["trade_start"],
            "trade_end"     => $row["trade_end"],
            "trade_id"      => $row["trade_id"],
            "lots_done"     => (float)$row["lots_done"],
            "reward_amount" => (float)$row["reward_amount"],
            "created_at"    => $row["created_at"]
        ];
    }
}

echo json_encode([
    "status" => "success",
    "data" => $users
]);
exit;
?>
