<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include_once __DIR__ . '/config.php';
include_once __DIR__ . '/connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

$input = json_decode(file_get_contents("php://input"), true);
$level = intval($input['level'] ?? 0);
$type = $input['type'] ?? '';

if ($level < 1 || empty($type)) {
    echo json_encode(["status"=>"error","message"=>"Invalid level or type"]);
    exit;
}

$columnName = "level_{$level}_{$type}_commission";
$sql = "ALTER TABLE ranks DROP COLUMN `$columnName`";

if ($conn->query($sql) === TRUE) {
    echo json_encode([
        "status"=>"success",
        "message"=>"Column $columnName deleted successfully"
    ]);
} else {
    echo json_encode([
        "status"=>"error",
        "message"=>"Error: ".$conn->error
    ]);
}
?>
